/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2008 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.system.vo;

import java.util.Iterator;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import jp.mosp.common.CommonConst;
import jp.mosp.common.vo.MosPVo;

import jp.mosp.system.dto.CmOutPutDto;

public class OutPutMasterListVo extends MosPVo {

	private static final long serialVersionUID = 6248095734423700381L;

	// URLACSS
	private static final String RETURN_URL = "/jsp/system/outPutMasterList.jsp";
	private static final String EXTRA_JS   = "/pub/system/js/outPutMasterList.js";
	private static final String EXTRA_CSS  = "/pub/system/css/outPutMasterList.css";

	// ʃTu^Cg
	public final String SUB_TITLE = CommonConst.TTL_OUTPUT_MASTER;

	//萔
	public static final int SEARCH_OFF = 0;
	public static final int SEARCH_ON  = 1;

	// p[^
	public static final String PRM_TXT_CODE	= "txtCode";
	public static final String PRM_TXT_NAME	= "txtName";
	public static final String PRM_PLT_SCOPE	= "pltScope";

	// tB[h
	private String[][] aryOutPutMaster;
	private String   txtCode;
	private String   txtName;
	private String   pltScope;

	// tB[hyѐ
	public static final String NAM_CODE	= CommonConst.NAM_CMD_PRINT;
	public static final String NAM_NAME	= CommonConst.NAM_BUTTON_NAME;
	public static final String NAM_SCOPE	= CommonConst.NAM_SCOPE;
	public static final String NAM_INDEX	= CommonConst.NAM_SHOW_ORDER;
	public static final int    LEN_NAME	= 20;

	// \[gL[
	public final String KEY_CODE	= "keyCode";
	public final String KEY_NAME	= "keyName";
	public final String KEY_SCOPE	= "keyScope";
	public final String KEY_INDEX	= "keyIndex";

	// [h(0FȂA1F)
	private int searchmode;

	// v_EXg
	public String[][] aryPltScope;

	/**
	 * RXgN^
	 */
	public OutPutMasterListVo() {
		super();
		setRetUrl(RETURN_URL);
		addExtraJs(EXTRA_JS);
		setExtraCss(EXTRA_CSS);
		txtCode			= "";
		txtName			= "";
		pltScope		= "";
		aryOutPutMaster	= new String[0][0];
		setFormerKey(KEY_CODE);
	}

	/**
	 * p[^ݒ
	 * @param request NGXg
	 */
	public void setParams(HttpServletRequest request) {
		txtCode		= request.getParameter(PRM_TXT_CODE);
		txtName		= request.getParameter(PRM_TXT_NAME);
		pltScope	= request.getParameter(PRM_PLT_SCOPE);
	}

	/**
	 * tB[hݒ
	 * @param listCode		CSVo̓}X^Xg
	 */
	public void setFields(List listCode) {
		// Xg̐ݒ
		list = listCode;
		// f[^̎擾
		count = listCode.size();
		// z̏
		aryOutPutMaster		= new String[count][4];
		// f[^̐ݒ
		int i = 0;
		Iterator it = listCode.iterator();
		while (it.hasNext()) {
			CmOutPutDto dto = (CmOutPutDto)it.next();
			aryOutPutMaster[i][0] = escapeHTML(dto.getCode());
			aryOutPutMaster[i][1] = escapeHTML(dto.getName());
			aryOutPutMaster[i][2] = escapeHTML(getCodeName(dto.getScope(), aryPltScope));
			aryOutPutMaster[i][3] = String.valueOf(dto.getViewIndex());
			i++;
		}
	}

	/**
	 * JavaScriptݒ
	 * @param cls 擾NX
	 * @throws IllegalAccessException
	 */
	@Override
	public String getDirectJs(Class cls) throws IllegalAccessException {
		StringBuffer sb = new StringBuffer();
		sb.append(super.getDirectJs(cls));
		return sb.toString();
	}

	// ANZT\bh
	public String[][] getEscAryOutPutMaster() { return aryOutPutMaster.clone(); }

	public String getTxtCode	() { return txtCode		; }
	public String getTxtName	() { return txtName		; }
	public String getPltScope	() { return pltScope	; }

	public String getEscTxtCode	() { return escapeHTML(txtCode)	; }
	public String getEscTxtName	() { return escapeHTML(txtName)	; }

	public void setSearchmode(int searchmode) { this.searchmode = searchmode; }
	public int getSearchmode() { return searchmode; }

}
